/*
 * Decompiled with CFR 0.152.
 */
package com.hc.jee.springbootstarter.course;

import com.hc.jee.springbootstarter.course.Course;
import com.hc.jee.springbootstarter.course.CourseService;
import com.hc.jee.springbootstarter.topic.Topic;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CourseController {
    @Autowired
    CourseService courseService;

    @RequestMapping(value={"/topics/{id}/courses"})
    public List<Course> getAllCourses(@PathVariable String id) {
        return this.courseService.getAllCourses(id);
    }

    @RequestMapping(value={"/topics/{topicId}/courses/{id}"})
    public Course getCourse(@PathVariable String id) {
        return this.courseService.getCourse(id);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/topics/{topicId}/courses"})
    public void addTopic(@RequestBody Course course, @PathVariable String topicId) {
        course.setTopic(new Topic(topicId, "", ""));
        this.courseService.addCourse(course);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/topics/{topicId}/courses/{id}"})
    public void updateTopic(@RequestBody Course course, @PathVariable String topicId, @PathVariable String id) {
        course.setTopic(new Topic(topicId, "", ""));
        this.courseService.updateCourse(id, course);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/topics/{topicId}/courses/{id}"})
    public void deleteTopic(@PathVariable String id) {
        this.courseService.deleteCourse(id);
    }
}

