/*
 * Decompiled with CFR 0.152.
 */
package com.hc.jee.springbootstarter.topic;

import com.hc.jee.springbootstarter.topic.Topic;
import com.hc.jee.springbootstarter.topic.TopicService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TopicController {
    @Autowired
    TopicService topicService;

    @RequestMapping(value={"/topics"})
    public List<Topic> getAllTopics() {
        return this.topicService.getAllTopics();
    }

    @RequestMapping(value={"/topics/{id}"})
    public Topic getTopic(@PathVariable String id) {
        return this.topicService.getTopic(id);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/topics"})
    public void addTopic(@RequestBody Topic topic) {
        this.topicService.addTopic(topic);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/topics/{id}"})
    public void updateTopic(@RequestBody Topic topic, @PathVariable String id) {
        this.topicService.updateTopic(id, topic);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/topics/{id}"})
    public void deleteTopic(@PathVariable String id) {
        this.topicService.deleteTopic(id);
    }
}

